/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.moduleviews;

import com.ldtteam.blockout.views.Window;
import com.minecolonies.api.colony.buildings.modules.AbstractBuildingModuleView;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.client.gui.modules.EnchanterStationModuleWindow;
import com.minecolonies.coremod.network.messages.server.colony.building.enchanter.EnchanterWorkerSetMessage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class EnchanterStationsModuleView
extends AbstractBuildingModuleView {
    private List<BlockPos> buildingToGatherFrom = new ArrayList<BlockPos>();

    @Override
    public void deserialize(@NotNull PacketBuffer buf) {
        int size = buf.readInt();
        this.buildingToGatherFrom.clear();
        for (int i = 0; i < size; ++i) {
            this.buildingToGatherFrom.add(buf.func_179259_c());
        }
    }

    public List<BlockPos> getBuildingsToGatherFrom() {
        return this.buildingToGatherFrom;
    }

    public void addWorker(BlockPos blockPos) {
        this.buildingToGatherFrom.add(blockPos);
        Network.getNetwork().sendToServer(new EnchanterWorkerSetMessage(this.buildingView, blockPos, true));
    }

    public void removeWorker(BlockPos blockPos) {
        this.buildingToGatherFrom.remove(blockPos);
        Network.getNetwork().sendToServer(new EnchanterWorkerSetMessage(this.buildingView, blockPos, false));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Window getWindow() {
        return new EnchanterStationModuleWindow(this.buildingView, this);
    }

    @Override
    public String getIcon() {
        return "entity";
    }

    @Override
    public String getDesc() {
        return "com.minecolonies.gui.workerhuts.enchanter.workers";
    }
}

